// =============================================================================
// LiquidBounce Script API - TypeScript Declaration File
// Generated for IDE autocomplete (VS Code / WebStorm)
// LiquidBounce NextGen - GraalJS Runtime
// =============================================================================

// =============================================================================
// JAVA BRIDGE
// =============================================================================

declare namespace Java {
    function type<T = any>(className: string): T;
}

// =============================================================================
// MINECRAFT TYPES (Partial - for Script API use)
// =============================================================================

interface MinecraftClient {
    readonly player: ClientPlayerEntity | null;
    readonly world: ClientWorld | null;
    readonly gameMode: ClientPlayerInteractionManager | null;
    close(): void;
    execute(runnable: () => void): void;
}

interface ClientPlayerEntity {
    getName(): TextComponent;
    getYaw(): number;
    getPitch(): number;
    getX(): number;
    getY(): number;
    getZ(): number;
    getEyeY(): number;
    getHealth(): number;
    getMaxHealth(): number;
    isOnGround(): boolean;
    isSneaking(): boolean;
    isSprinting(): boolean;
    isSwimming(): boolean;
    isClimbing(): boolean;
    isFallFlying(): boolean;
    isUsingItem(): boolean;
    getItemInHand(hand: InteractionHand): ItemStack;
    getMainHandItem(): ItemStack;
    getOffhandItem(): ItemStack;
    getInventory(): PlayerInventory;
    setDeltaMovement(velocity: Vec3d): void;
    readonly deltaMovement: Vec3d;
    readonly position: Vec3d;
    readonly eyePosition: Vec3d;
    readonly boundingBox: Box;
    readonly horizontalCollision: boolean;
    readonly verticalCollision: boolean;
    readonly xRot: number;
    readonly yRot: number;
}

interface ClientWorld {
    getScoreboard(): Scoreboard;
    getBlockState(pos: BlockPos): BlockState;
    getEntities(): Iterable<Entity>;
    getPlayers(): Iterable<ClientPlayerEntity>;
}

interface ClientPlayerInteractionManager {
    interact(player: ClientPlayerEntity, entity: Entity, hand: InteractionHand): ActionResult;
    useItem(player: ClientPlayerEntity, hand: InteractionHand): ActionResult;
}

interface Entity {
    getId(): number;
    getName(): TextComponent;
    getX(): number;
    getY(): number;
    getZ(): number;
    getYaw(): number;
    getPitch(): number;
    isAlive(): boolean;
    isRemoved(): boolean;
    readonly boundingBox: Box;
    readonly position: Vec3d;
}

interface LivingEntity extends Entity {
    getHealth(): number;
    getMaxHealth(): number;
    isDeadOrDying(): boolean;
}

interface PlayerInventory {
    getMainHandStack(): ItemStack;
    getStack(slot: number): ItemStack;
    readonly selectedSlot: number;
}

interface ItemStack {
    isEmpty(): boolean;
    getCount(): number;
    getItem(): Item;
    getName(): TextComponent;
}

interface Item {
    getName(): TextComponent;
}

interface TextComponent {
    getString(): string;
    toString(): string;
}

interface Vec3d {
    readonly x: number;
    readonly y: number;
    readonly z: number;
    add(x: number, y: number, z: number): Vec3d;
    add(other: Vec3d): Vec3d;
    subtract(x: number, y: number, z: number): Vec3d;
    subtract(other: Vec3d): Vec3d;
    multiply(scalar: number): Vec3d;
    normalize(): Vec3d;
    length(): number;
    lengthSquared(): number;
    distanceTo(other: Vec3d): number;
    squaredDistanceTo(other: Vec3d): number;
}

interface Vec3i {
    readonly x: number;
    readonly y: number;
    readonly z: number;
}

interface BlockPos extends Vec3i {
    up(): BlockPos;
    down(): BlockPos;
    north(): BlockPos;
    south(): BlockPos;
    east(): BlockPos;
    west(): BlockPos;
    offset(direction: Direction, distance?: number): BlockPos;
}

interface BlockState {
    getBlock(): Block;
    isAir(): boolean;
    isSolid(): boolean;
}

interface Block {
    getName(): TextComponent;
}

interface Box {
    readonly minX: number;
    readonly minY: number;
    readonly minZ: number;
    readonly maxX: number;
    readonly maxY: number;
    readonly maxZ: number;
    readonly center: Vec3d;
    contains(x: number, y: number, z: number): boolean;
    contains(pos: Vec3d): boolean;
    intersects(other: Box): boolean;
    expand(value: number): Box;
    contract(value: number): Box;
}

interface Scoreboard {
    getPlayersTeam(playerName: string): Team | null;
}

interface Team {
    getName(): string;
    getColor(): ChatFormatting;
}

interface ChatFormatting {
    toString(): string;
}

interface Rotation {
    readonly yaw: number;
    readonly pitch: number;
}

interface Direction {
    readonly name: string;
}

interface ActionResult {
    isAccepted(): boolean;
    shouldSwingHand(): boolean;
}

declare const InteractionHand: {
    readonly MAIN_HAND: InteractionHand;
    readonly OFF_HAND: InteractionHand;
};
type InteractionHand = { readonly name: string };

// =============================================================================
// SCRIPT REGISTRATION
// =============================================================================

interface ScriptInfo {
    name: string;
    version: string;
    authors: string | string[];
}

interface Script {
    registerModule(
        moduleOptions: ModuleOptions,
        callback: (module: ScriptModule) => void
    ): void;
    
    registerCommand(commandOptions: CommandOptions): void;
    
    registerChoice(
        choiceConfigurable: ChoiceConfigurable,
        choiceOptions: ChoiceOptions,
        callback: (choice: ScriptChoice) => void
    ): void;
    
    on(event: "load" | "enable" | "disable", handler: () => void): void;
}

declare function registerScript(info: ScriptInfo): Script;

// =============================================================================
// MODULE SYSTEM
// =============================================================================

type ModuleCategory = 
    | "Combat"
    | "Player"
    | "Movement"
    | "Render"
    | "Client"
    | "World"
    | "Misc"
    | "Fun"
    | "Exploit";

interface ModuleOptions {
    name: string;
    category: ModuleCategory;
    description?: string;
    tag?: string;
    settings?: Record<string, SettingValue<unknown>>;
}

interface ScriptModule {
    readonly name: string;
    readonly category: ModuleCategory;
    readonly settings: Record<string, SettingValue<unknown>>;
    enabled: boolean;
    tag: string | null;
    
    on(event: "enable", handler: () => void): void;
    on(event: "disable", handler: () => void): void;
    on<E extends EventName>(event: E, handler: (event: EventMap[E]) => void): void;
}

// =============================================================================
// EVENTS
// =============================================================================

type EventName =
    | "clickGuiScaleChange"
    | "clickGuiValueChange"
    | "spaceSeperatedNamesChange"
    | "clientStart"
    | "clientShutdown"
    | "clientLanguageChanged"
    | "valueChanged"
    | "moduleActivation"
    | "moduleToggle"
    | "refreshArrayList"
    | "notification"
    | "gameModeChange"
    | "targetChange"
    | "blockCountChange"
    | "bedStateChange"
    | "clientChatStateChange"
    | "clientChatMessage"
    | "clientChatError"
    | "clientChatJwtToken"
    | "accountManagerMessage"
    | "accountManagerLogin"
    | "accountManagerAddition"
    | "accountManagerRemoval"
    | "proxyCheckResult"
    | "browserReady"
    | "virtualScreen"
    | "serverPinged"
    | "componentsUpdate"
    | "rotationUpdate"
    | "resourceReload"
    | "scaleFactorChange"
    | "scheduleInventoryAction"
    | "selectHotbarSlotSilently"
    | "browserUrlChange"
    | "gameTick"
    | "gameRenderTaskQueue"
    | "tickPacketProcess"
    | "key"
    | "inputHandle"
    | "movementInput"
    | "sprint"
    | "mouseRotation"
    | "keybindChange"
    | "keybindIsPressed"
    | "useCooldown"
    | "cancelBlockBreaking"
    | "allowAutoJump"
    | "session"
    | "screen"
    | "chatSend"
    | "chatReceive"
    | "serverConnect"
    | "disconnect"
    | "overlayMessage"
    | "perspective"
    | "itemLoreQuery"
    | "healthUpdate"
    | "death"
    | "playerTick"
    | "playerPostTick"
    | "playerMovementTick"
    | "playerNetworkMovementTick"
    | "playerPushOut"
    | "playerMove"
    | "playerJump"
    | "playerAfterJump"
    | "playerUseMultiplier"
    | "playerSneakMultiplier"
    | "playerInteractItem"
    | "playerInteractedItem"
    | "playerStrafe"
    | "playerStride"
    | "playerSafeWalk"
    | "playerStep"
    | "playerStepSuccess"
    | "playerFluidCollisionCheck"
    | "pipeline"
    | "packet"
    | "queuePacket"
    | "gameRender"
    | "screenRender"
    | "worldRender"
    | "drawOutlines"
    | "overlayRender"
    | "worldChange"
    | "chunkUnload"
    | "chunkLoad"
    | "chunkDeltaUpdate"
    | "blockChange"
    | "blockShape"
    | "blockBreakingProgress"
    | "blockAttack"
    | "blockVelocityMultiplier"
    | "blockSlipperinessMultiplier"
    | "entityEquipmentChange"
    | "fluidPush"
    | "worldEntityRemove"
    | "attack"
    | "entityMargin"
    | "entityHealthUpdate"
    | "tagEntityEvent";

interface BaseEvent {
    readonly isCompleted: boolean;
}

interface CancellableEvent extends BaseEvent {
    isCancelled: boolean;
    cancelEvent(): void;
}

interface GameTickEvent extends BaseEvent {}

interface KeyEvent extends BaseEvent {
    readonly key: InputKey;
    readonly action: number;
}

interface InputKey {
    readonly code: number;
    readonly name: string;
}

interface MovementInputEvent extends BaseEvent {
    directionalInput: DirectionalInput;
    jump: boolean;
    sneak: boolean;
}

interface DirectionalInput {
    forwards: boolean;
    backwards: boolean;
    left: boolean;
    right: boolean;
}

interface SprintEvent extends BaseEvent {
    readonly directionalInput: DirectionalInput;
    sprint: boolean;
    readonly source: "INPUT" | "MOVEMENT_TICK" | "NETWORK";
}

interface MouseRotationEvent extends CancellableEvent {
    cursorDeltaX: number;
    cursorDeltaY: number;
}

interface ChatSendEvent extends CancellableEvent {
    readonly message: string;
}

interface ChatReceiveEvent extends CancellableEvent {
    readonly message: string;
    readonly textData: TextComponent;
    readonly type: "CHAT_MESSAGE" | "DISGUISED_CHAT_MESSAGE" | "GAME_MESSAGE";
    applyChatDecoration(component: TextComponent): TextComponent;
}

interface ScreenEvent extends CancellableEvent {
    readonly screen: unknown | null;
}

interface HealthUpdateEvent extends BaseEvent {
    readonly health: number;
    readonly food: number;
    readonly saturation: number;
    readonly previousHealth: number;
}

interface DeathEvent extends BaseEvent {}

interface PlayerTickEvent extends CancellableEvent {}

interface PlayerMoveEvent extends BaseEvent {
    readonly type: unknown;
    movement: Vec3d;
}

interface PlayerJumpEvent extends CancellableEvent {
    motion: number;
    yaw: number;
}

interface PlayerNetworkMovementTickEvent extends CancellableEvent {
    readonly state: "PRE" | "POST";
    x: number;
    y: number;
    z: number;
    ground: boolean;
}

interface PacketEvent extends CancellableEvent {
    readonly origin: "INCOMING" | "OUTGOING";
    readonly packet: unknown;
    readonly original: boolean;
}

interface WorldRenderEvent extends BaseEvent {
    readonly matrixStack: unknown;
    readonly camera: unknown;
    readonly partialTicks: number;
}

interface OverlayRenderEvent extends BaseEvent {
    readonly context: GuiGraphics;
    readonly tickDelta: number;
}

interface GuiGraphics {
    fill(x1: number, y1: number, x2: number, y2: number, color: number): void;
    drawString(font: unknown, text: string, x: number, y: number, color: number): void;
}

interface WorldChangeEvent extends BaseEvent {
    readonly world: ClientWorld | null;
}

interface BlockChangeEvent extends BaseEvent {
    readonly blockPos: BlockPos;
    readonly newState: BlockState;
}

interface AttackEntityEvent extends BaseEvent {
    readonly entity: Entity;
}

interface EntityMarginEvent extends BaseEvent {
    readonly entity: Entity;
    margin: number;
}

interface EntityHealthUpdateEvent extends BaseEvent {
    readonly entity: LivingEntity;
    readonly old: number;
    readonly new: number;
    readonly max: number;
}

interface NotificationEvent extends BaseEvent {
    readonly title: string;
    readonly message: string;
    readonly severity: "INFO" | "SUCCESS" | "ERROR" | "ENABLED" | "DISABLED";
}

interface ModuleToggleEvent extends BaseEvent {
    readonly moduleName: string;
    readonly hidden: boolean;
    readonly enabled: boolean;
}

interface EventMap {
    clickGuiScaleChange: BaseEvent;
    clickGuiValueChange: BaseEvent;
    spaceSeperatedNamesChange: BaseEvent;
    clientStart: BaseEvent;
    clientShutdown: BaseEvent;
    clientLanguageChanged: BaseEvent;
    valueChanged: BaseEvent;
    moduleActivation: BaseEvent;
    moduleToggle: ModuleToggleEvent;
    refreshArrayList: BaseEvent;
    notification: NotificationEvent;
    gameModeChange: BaseEvent;
    targetChange: BaseEvent;
    blockCountChange: BaseEvent;
    bedStateChange: BaseEvent;
    clientChatStateChange: BaseEvent;
    clientChatMessage: BaseEvent;
    clientChatError: BaseEvent;
    clientChatJwtToken: BaseEvent;
    accountManagerMessage: BaseEvent;
    accountManagerLogin: BaseEvent;
    accountManagerAddition: BaseEvent;
    accountManagerRemoval: BaseEvent;
    proxyCheckResult: BaseEvent;
    browserReady: BaseEvent;
    virtualScreen: BaseEvent;
    serverPinged: BaseEvent;
    componentsUpdate: BaseEvent;
    rotationUpdate: BaseEvent;
    resourceReload: BaseEvent;
    scaleFactorChange: BaseEvent;
    scheduleInventoryAction: BaseEvent;
    selectHotbarSlotSilently: CancellableEvent;
    browserUrlChange: BaseEvent;
    gameTick: GameTickEvent;
    gameRenderTaskQueue: BaseEvent;
    tickPacketProcess: BaseEvent;
    key: KeyEvent;
    inputHandle: BaseEvent;
    movementInput: MovementInputEvent;
    sprint: SprintEvent;
    mouseRotation: MouseRotationEvent;
    keybindChange: BaseEvent;
    keybindIsPressed: BaseEvent;
    useCooldown: BaseEvent;
    cancelBlockBreaking: CancellableEvent;
    allowAutoJump: BaseEvent;
    session: BaseEvent;
    screen: ScreenEvent;
    chatSend: ChatSendEvent;
    chatReceive: ChatReceiveEvent;
    serverConnect: CancellableEvent;
    disconnect: BaseEvent;
    overlayMessage: BaseEvent;
    perspective: BaseEvent;
    itemLoreQuery: BaseEvent;
    healthUpdate: HealthUpdateEvent;
    death: DeathEvent;
    playerTick: PlayerTickEvent;
    playerPostTick: BaseEvent;
    playerMovementTick: BaseEvent;
    playerNetworkMovementTick: PlayerNetworkMovementTickEvent;
    playerPushOut: CancellableEvent;
    playerMove: PlayerMoveEvent;
    playerJump: PlayerJumpEvent;
    playerAfterJump: BaseEvent;
    playerUseMultiplier: BaseEvent;
    playerSneakMultiplier: BaseEvent;
    playerInteractItem: CancellableEvent;
    playerInteractedItem: BaseEvent;
    playerStrafe: BaseEvent;
    playerStride: BaseEvent;
    playerSafeWalk: BaseEvent;
    playerStep: BaseEvent;
    playerStepSuccess: BaseEvent;
    playerFluidCollisionCheck: CancellableEvent;
    pipeline: BaseEvent;
    packet: PacketEvent;
    queuePacket: BaseEvent;
    gameRender: BaseEvent;
    screenRender: BaseEvent;
    worldRender: WorldRenderEvent;
    drawOutlines: BaseEvent;
    overlayRender: OverlayRenderEvent;
    worldChange: WorldChangeEvent;
    chunkUnload: BaseEvent;
    chunkLoad: BaseEvent;
    chunkDeltaUpdate: BaseEvent;
    blockChange: BlockChangeEvent;
    blockShape: BaseEvent;
    blockBreakingProgress: BaseEvent;
    blockAttack: CancellableEvent;
    blockVelocityMultiplier: BaseEvent;
    blockSlipperinessMultiplier: BaseEvent;
    entityEquipmentChange: BaseEvent;
    fluidPush: CancellableEvent;
    worldEntityRemove: BaseEvent;
    attack: AttackEntityEvent;
    entityMargin: EntityMarginEvent;
    entityHealthUpdate: EntityHealthUpdateEvent;
    tagEntityEvent: BaseEvent;
}

// =============================================================================
// SETTINGS API
// =============================================================================

interface SettingValue<T> {
    value: T;
    readonly name: string;
}

interface BooleanSettingOptions {
    name: string;
    default: boolean;
}

interface FloatSettingOptions {
    name: string;
    default: number;
    range: [number, number];
    suffix?: string;
}

interface FloatRangeSettingOptions {
    name: string;
    default: [number, number];
    range: [number, number];
    suffix?: string;
}

interface IntSettingOptions {
    name: string;
    default: number;
    range: [number, number];
    suffix?: string;
}

interface IntRangeSettingOptions {
    name: string;
    default: [number, number];
    range: [number, number];
    suffix?: string;
}

interface KeySettingOptions {
    name: string;
    default: string;
}

interface TextSettingOptions {
    name: string;
    default: string;
}

interface TextArraySettingOptions {
    name: string;
    default: string[];
}

interface ChooseSettingOptions {
    name: string;
    choices: string[];
    default: string;
}

interface MultiChooseSettingOptions {
    name: string;
    choices: string[];
    default?: string[];
    canBeNone?: boolean;
}

declare const Setting: {
    boolean(options: BooleanSettingOptions): SettingValue<boolean>;
    float(options: FloatSettingOptions): SettingValue<number>;
    floatRange(options: FloatRangeSettingOptions): SettingValue<[number, number]>;
    int(options: IntSettingOptions): SettingValue<number>;
    intRange(options: IntRangeSettingOptions): SettingValue<[number, number]>;
    key(options: KeySettingOptions): SettingValue<InputKey>;
    text(options: TextSettingOptions): SettingValue<string>;
    textArray(options: TextArraySettingOptions): SettingValue<string[]>;
    choose(options: ChooseSettingOptions): SettingValue<string>;
    multiChoose(options: MultiChooseSettingOptions): SettingValue<string[]>;
};

// =============================================================================
// COMMANDS API
// =============================================================================

interface CommandOptions {
    name: string;
    aliases?: string[];
    parameters?: ParameterOptions[];
    subcommands?: CommandOptions[];
    hub?: boolean;
    onExecute?(...args: unknown[]): void;
}

interface ParameterOptions {
    name: string;
    required?: boolean;
    vararg?: boolean;
    getCompletions?(begin: string, args: string[]): string[];
    validate?(param: string): ValidationResult;
}

interface ValidationResult {
    accept: boolean;
    value?: unknown;
    error?: string;
}

// =============================================================================
// CHOICE API
// =============================================================================

interface ChoiceConfigurable {
    readonly choices: ScriptChoice[];
}

interface ChoiceOptions {
    name: string;
    settings?: Record<string, SettingValue<unknown>>;
}

interface ScriptChoice {
    readonly name: string;
    readonly settings: Record<string, SettingValue<unknown>>;
    on(event: "enable", handler: () => void): void;
    on(event: "disable", handler: () => void): void;
    on<E extends EventName>(event: E, handler: (event: EventMap[E]) => void): void;
}

// =============================================================================
// GLOBAL CLASSES - Client
// =============================================================================

interface ScriptClientType {
    readonly eventManager: EventManager;
    readonly configSystem: ConfigSystem;
    readonly moduleManager: ModuleManager;
    readonly commandManager: CommandManager;
    readonly scriptManager: ScriptManager;
    readonly combatManager: CombatManager;
    displayChatMessage(message: string): void;
}

interface EventManager {
    callEvent(event: BaseEvent): void;
}

interface ConfigSystem {}

interface ModuleManager {
    getModule(name: string): ClientModule | null;
    getModules(): ClientModule[];
}

interface ClientModule {
    readonly name: string;
    readonly category: ModuleCategory;
    enabled: boolean;
    readonly settings: Record<string, SettingValue<unknown>>;
}

interface CommandManager {
    getCommand(name: string): unknown | null;
}

interface ScriptManager {
    readonly root: { path: string };
}

interface CombatManager {}

declare const Client: ScriptClientType;

// =============================================================================
// GLOBAL CLASSES - AsyncUtil (JavaScript only)
// =============================================================================

interface AsyncUtilType {
    ticks(n: number): Promise<number>;
    until(condition: () => boolean): Promise<number>;
    conditional(ticks: number, breakLoop: () => boolean): Promise<number>;
    request(block: (builder: RequestBuilder) => void): Promise<Response>;
    launch<T>(block: () => T): Promise<T>;
    launch<T>(executor: Executor, block: () => T): Promise<T>;
}

interface RequestBuilder {
    url(url: string): RequestBuilder;
    method(method: string): RequestBuilder;
    header(name: string, value: string): RequestBuilder;
    body(body: unknown): RequestBuilder;
}

interface Response {
    readonly code: number;
    readonly message: string;
    body(): ResponseBody;
}

interface ResponseBody {
    string(): string;
    bytes(): number[];
}

interface Executor {
    execute(runnable: () => void): void;
}

declare const AsyncUtil: AsyncUtilType;

// =============================================================================
// GLOBAL CLASSES - BlockUtil
// =============================================================================

interface BlockUtilType {
    newBlockPos(x: number, y: number, z: number): BlockPos;
    getBlock(blockPos: BlockPos): Block;
    getState(blockPos: BlockPos): BlockState | null;
}

declare const BlockUtil: BlockUtilType;

// =============================================================================
// GLOBAL CLASSES - InteractionUtil
// =============================================================================

interface InteractionUtilType {
    attackEntity(entity: Entity, swing: boolean, keepSprint: boolean): void;
    interactEntity(entity: Entity, hand: InteractionHand): void;
    useItem(hand: InteractionHand): void;
    placeBlock(blockPos: BlockPos, hand: InteractionHand): boolean;
}

declare const InteractionUtil: InteractionUtilType;

// =============================================================================
// GLOBAL CLASSES - ItemUtil
// =============================================================================

interface ItemUtilType {
    create(arguments: string): ItemStack;
    create(arguments: string, amount: number): ItemStack;
}

declare const ItemUtil: ItemUtilType;

// =============================================================================
// GLOBAL CLASSES - MovementUtil
// =============================================================================

interface MovementUtilType {
    getSpeed(): number;
    isMoving(): boolean;
    strafe(): void;
    strafeWithSpeed(speed: number): void;
    strafeWithStrength(strength: number): void;
    strafeWithSpeedAndStrength(speed: number, strength: number): void;
}

declare const MovementUtil: MovementUtilType;

// =============================================================================
// GLOBAL CLASSES - NetworkUtil
// =============================================================================

interface NetworkUtilType {
    movePlayerGround(onGround: boolean, horizontalCollision: boolean): void;
    movePlayerPosition(x: number, y: number, z: number, onGround: boolean, horizontalCollision: boolean): void;
    movePlayerPositionAndLook(
        x: number,
        y: number,
        z: number,
        yaw: number,
        pitch: number,
        onGround: boolean,
        horizontalCollision: boolean
    ): void;
    movePlayerLook(yaw: number, pitch: number, onGround: boolean, horizontalCollision: boolean): void;
    sendChatMessage(message: string): void;
    sendCommand(command: string): void;
}

declare const NetworkUtil: NetworkUtilType;

// =============================================================================
// GLOBAL CLASSES - ParameterValidator
// =============================================================================

interface ParameterValidatorType {
    string(param: string): ValidationResult;
    module(param: string): ValidationResult;
    integer(param: string): ValidationResult;
    positiveInteger(param: string): ValidationResult;
}

declare const ParameterValidator: ParameterValidatorType;

// =============================================================================
// GLOBAL CLASSES - Primitives
// =============================================================================

interface PrimitivesType {
    boolean(value: boolean): boolean;
    boolean(value: string | null): boolean;
    byte(value: number): number;
    byte(value: string | null, radix?: number): number;
    short(value: number): number;
    short(value: string | null, radix?: number): number;
    char(value: number): string;
    char(value: string | null): string;
    int(value: number): number;
    int(value: string | null, radix?: number): number;
    long(value: number): number;
    long(value: string | null, radix?: number): number;
    float(value: number): number;
    float(value: string | null): number;
    double(value: number): number;
    double(value: string | null): number;
}

declare const Primitives: PrimitivesType;

// =============================================================================
// GLOBAL CLASSES - ReflectionUtil
// =============================================================================

interface ReflectionUtilType {
    invalidateCache(): void;
    classByName(name: string): JavaClass;
    newInstance(clazz: JavaClass, ...args: unknown[]): unknown;
    newInstanceByName(name: string, ...args: unknown[]): unknown;
    newInstanceByObject(obj: unknown, ...args: unknown[]): unknown;
    getField(obj: unknown, name: string): unknown;
    getDeclaredField(clazz: JavaClass, name: string): unknown;
    invokeMethod(obj: unknown, name: string, ...args: unknown[]): unknown;
    invokeDeclaredMethod(clazz: JavaClass, name: string, ...args: unknown[]): unknown;
}

interface JavaClass {
    readonly name: string;
}

declare const ReflectionUtil: ReflectionUtilType;

// =============================================================================
// GLOBAL CLASSES - RotationUtil
// =============================================================================

interface RotationUtilType {
    newRaytracedRotationEntity(entity: Entity, range: number, throughWallsRange: number): Rotation | null;
    newRotationEntity(entity: Entity): Rotation;
    aimAtRotation(rotation: Rotation, fixVelocity: boolean): void;
}

declare const RotationUtil: RotationUtilType;

// =============================================================================
// GLOBAL CLASSES - UnsafeThread
// =============================================================================

interface UnsafeThreadType {
    run(runnable: () => void): void;
}

declare const UnsafeThread: UnsafeThreadType;

// =============================================================================
// GLOBAL INSTANCES
// =============================================================================

declare const mc: MinecraftClient;

declare const localStorage: Record<string, unknown>;

// =============================================================================
// MINECRAFT CLASS CONSTRUCTORS
// =============================================================================

declare const Vec3d: {
    new(x: number, y: number, z: number): Vec3d;
    readonly ZERO: Vec3d;
};

declare const Vec3i: {
    new(x: number, y: number, z: number): Vec3i;
};

declare const BlockPos: {
    new(x: number, y: number, z: number): BlockPos;
    new(vec: Vec3i): BlockPos;
    new(vec: Vec3d): BlockPos;
};

declare const MathHelper: {
    floor(value: number): number;
    ceil(value: number): number;
    clamp(value: number, min: number, max: number): number;
    lerp(delta: number, start: number, end: number): number;
    abs(value: number): number;
    sin(value: number): number;
    cos(value: number): number;
    sqrt(value: number): number;
    wrapDegrees(degrees: number): number;
};

declare const Hand: typeof InteractionHand;

declare const RotationAxis: {
    readonly POSITIVE_X: RotationAxisInstance;
    readonly POSITIVE_Y: RotationAxisInstance;
    readonly POSITIVE_Z: RotationAxisInstance;
    readonly NEGATIVE_X: RotationAxisInstance;
    readonly NEGATIVE_Y: RotationAxisInstance;
    readonly NEGATIVE_Z: RotationAxisInstance;
};

interface RotationAxisInstance {
    rotationDegrees(degrees: number): Quaternion;
}

interface Quaternion {}
