const script = registerScript({
    name: "KeepDistance",
    version: "1.0",
    authors: ["konfeta6664"]
});

script.registerModule({
    name: "KeepDistance",
    category: "Movement",
    description: "Prevents the player from moving into the range of an enemy (bypass-friendly).",
    settings: {
        range: Setting.float({
            name: "Range",
            default: 6.0,
            range: [1.0, 20.0],
            suffix: " blocks"
        })
    }
}, module => {
    let DirectionalInput = null;

    module.on("enable", () => {
        DirectionalInput = Java.type("net.ccbluex.liquidbounce.utils.movement.DirectionalInput");
    });

    module.on("movementInput", event => {
        const world = mc.level;
        const me = mc.player;

        if (!me || !world) return;

        const rangeSq = module.settings.range.value ** 2;
        const myX = me.getX(), myY = me.getY(), myZ = me.getZ();

        let enemyNearby = false;

        for (const p of world.players()) {
            if (p === me || typeof p.getX !== "function") continue;

            const dx = myX - p.getX();
            const dy = myY - p.getY();
            const dz = myZ - p.getZ();

            if (dx * dx + dy * dy + dz * dz <= rangeSq) {
                enemyNearby = true;
                break; 
            }
        }

        if (enemyNearby) {
            event.directionalInput = DirectionalInput.NONE;
            event.jump = event.sneak = false; 
        }
    });
});
